
function number = replacement(fit,total_elem_num,mu)

% The index of all the individuals in the population
temp_number = 1:total_elem_num;

% Popsize--the number of the individuals that has been selected
popsize = 0;

% Number -- the set of the indexes
number = [];

% Select mu individuals from the population
while popsize < mu
    
    % R -- the set of the rank values of all the individuals
    R = [];
    
    % Compute the rank values of individuals
    for i = 1:length(temp_number)
        R(i) = length(find((fit(i,1) >= fit(:,1)) & (fit(i,2) >= fit(:,2)) & ((fit(i,1) > fit(:,1)) | (fit(i,2) > fit(:,2)))));
    end
    
    % Find individuals whose rank value is equal to 0, i.e., the Pareto front
    temp = (find(R == 0));
    
    % Sort individuals in the Pareto front by the degree of constraint violations
    [mouse,nouse] = sort(fit(temp,2));
    temp = temp(nouse);
    
    % Select the half of individuals in the Pareto front after sorting
    if round(length(temp) * 1/2) >= 1
        temp = temp(1 : round(length(temp) * 1/2));
    end
    
    % Put the indexes of selected individuals into the set 'number'
    number = [number temp_number(temp)];
    % Delete the indexes of selected individuals from 'temp_number'
    temp_number(temp) = [];
    % Delete the fitness values of selected individuals from 'fit'
    fit(temp,:) = [];
    % Recalculate the number of selected individuals
    popsize = popsize + length(temp);
    
end
% Select the first mu individuals
number = number(1:mu);